package parser.visitor;

import parser.*;

/**
 * Algo to run a given ACheckTagsAlgo on the n'th (starting at zero) 
 * SequenceSymbol in a linear list of chained SequenceTokens (ie. connected
 * via their second tokens).
 * Note that the given algo is executed on the n'th SequenceSymbol in the
 * chain, not the first symbol of that SequenceSymbol.   This allows the given
 * algo to continue recurring down the chain.
 * The first input is the number of the SequenceSymbol to go to, starting at zero.
 * The second input is the algo for that SequenceSymbol to execute (no input params).
 */
public class CheckNthSequenceAlgo extends ACheckTagsAlgo<Object> {
  public static final CheckNthSequenceAlgo Singleton = new CheckNthSequenceAlgo();
  
  private CheckNthSequenceAlgo(){}
  
  public Boolean seqCase(SequenceSymbol host, Object... inps) {
    int n = (Integer) inps[0];
    if(0 == n){ // Found it!
      // Run the given algo on the host, NOT host.getSymbol1()!
      return host.execute((ACheckTagsAlgo<?>) inps[1]);
    }
    else {
      // Keep counting down
      return host.getSymbol2().execute(this, --n, inps[1]);
    }
  }
}

